#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
// Expanding Ripple MeshMod01.fsh    by  FabriceNeyret2    
//https://www.shadertoy.com/view/XXfcR8
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D texture0;
uniform sampler2D texture1;
uniform sampler2D texture2;
uniform sampler2D texture3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

// Golfing 1826 chars "Expanding Ripple Mesh" by incre_ment. https://shadertoy.com/view/McjBWd

#define fragColor O
#define fragCoord u
//void mainImage( out vec4 O, vec2 u ) {
//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{ 
   float t = fract(.3*iTime), 
         z = 21., l = z;
   vec2  V;
   
   for (int k; k < 45; k++ ) {             // unified loop: k/5 for neighbor cells, k%2 for polygon
       vec2 R = iResolution.xy, 
            U = z * ( u - .5* R ) / R.y,
            Q = vec2( k/5%3, k/5/3 ) - 1.,
            C = ( round(U) + Q ) / z,      // cell
            e = abs(C) *R.x/R,             // to clamp the carpet
            P = fract(U +.5) - .5 - Q,     // local coordiates         
            A =  float(k%5%4/2*2-1) * vec2( k%5%2*2-1 , 1 ) * .5, // .5 = xCutoff
                                     // * min(.5, .35*(  1. + sin ( 6.283*(t - 2.*length(C)) ))),
            p =  C + A/z,
            W = V;                        // prev point on polygon
            V = A + .5* cos(  6.3*( t - 4.*length(p) ) + atan(p.y,p.x) +vec2(0,11)); // cur point
        k%5>0  && max(e.x,e.y)  < .7 ? e = W - V, // draw line from prev to cur
              l = min( l, length( P-V - e * clamp( dot(P-V,e)/dot(e,e), 0., 1. ) ) ) :l;
   }
   fragColor = vec4( .035 / abs(l) );             // AA-draw with halo
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below 
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 vTexCoord = gl_TexCoord[0];
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
//gl_FragColor.a = length(gl_FragColor.rgb);
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

